﻿namespace Code6587EN.Ch05.SetupVersioning
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Administration;
    using System;

    /// <summary>
    /// Console Application to configured versioning on a Pages Library
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Open the Site Collection that will contain the new Publishing Site
            using (var site = new SPSite("http://sharepoint/publishing"))
            {
                // Open the Site
                using (var web = site.OpenWeb())
                {
                    // Get the Pages Library
                    var pages = web.Lists["Pages"];

                    // Enable Versioning
	                pages.EnableVersioning = true;
	                pages.EnableMinorVersions = true;
	
	                // Add limits to the number of major and minor versions
	                pages.MajorWithMinorVersionsLimit = 25;
	                pages.MajorVersionLimit = 25;

	                // Configure who can see draft items
                    pages.DraftVersionVisibility = DraftVisibilityType.Author;

                    // Require items to be checked-out before being able to edit them
                    pages.ForceCheckout = true;

                    // Update the Pages Library
                    pages.Update();
                }
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
